/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.recipes.crafting.recipes;

import crystalspider.justverticalslabs.JustVerticalSlabsLoader;
import crystalspider.justverticalslabs.recipes.crafting.VerticalSlabCraftingRecipe;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;

public class WaxedVerticalSlabCraftingRecipe
extends VerticalSlabCraftingRecipe {
    public static final String ID = "waxed_vertical_slab_crafting_recipe";
    private static final ResourceLocation RESOURCE_LOCATION = VerticalSlabUtils.getResourceLocation("waxed_vertical_slab_crafting_recipe");

    public WaxedVerticalSlabCraftingRecipe() {
        super(1, 1);
    }

    @Override
    @Nonnull
    public ItemStack assemble(@Nonnull ItemStack matchedItem) {
        Item slab = (Item)VerticalSlabUtils.MapsManager.waxingMap.get((Object)VerticalSlabUtils.getReferredSlabState(matchedItem).m_60734_().m_5456_());
        return VerticalSlabUtils.getVerticalSlabItem((BlockState)VerticalSlabUtils.MapsManager.slabStateMap.get((Object)slab), VerticalSlabUtils.isTranslucent(slab));
    }

    public ResourceLocation m_6423_() {
        return RESOURCE_LOCATION;
    }

    public Serializer getSerializer() {
        return (Serializer)JustVerticalSlabsLoader.WAXED_VERTICAL_SLAB_CRAFTING_RECIPE_SERIALIZER.get();
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Override
    protected Integer getMatchIndex(CraftingContainer craftingContainer) {
        boolean correctPattern = true;
        boolean hasHoneycomb = false;
        Integer matchIndex = null;
        for (int i = 0; i < craftingContainer.m_6643_() && correctPattern; ++i) {
            ItemStack itemStack = craftingContainer.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (matchIndex == null && this.isVerticalSlab(itemStack) && VerticalSlabUtils.MapsManager.waxingMap.containsKey((Object)VerticalSlabUtils.getReferredSlabState(itemStack).m_60734_().m_5456_())) {
                matchIndex = i;
                continue;
            }
            if (!hasHoneycomb && itemStack.m_150930_(Items.f_42784_)) {
                hasHoneycomb = true;
                continue;
            }
            matchIndex = null;
            correctPattern = false;
        }
        return hasHoneycomb ? matchIndex : null;
    }

    public static class Serializer
    extends VerticalSlabCraftingRecipe.Serializer<WaxedVerticalSlabCraftingRecipe> {
        public static final String ID = "waxed_vertical_slab_crafting_recipe_serializer";
        public static final ResourceLocation RESOURCE_LOCATION = VerticalSlabUtils.getResourceLocation("waxed_vertical_slab_crafting_recipe_serializer");

        public Serializer() {
            super(WaxedVerticalSlabCraftingRecipe::new);
        }
    }
}

